<?php

/*
 * Copyright (C) 2002-2013 AfterLogic Corp. (www.afterlogic.com)
 * Distributed under the terms of the license described in LICENSE
 *
 */
	include_once __DIR__.'/webmail/libraries/afterlogic/api.php';
	session_start();

	if (class_exists('CApi') && CApi::IsValid())
	{
		$sEmail = $_SESSION['mail_username'];
		$sPassword = base64_decode($_SESSION['mail_password']);

		try
		{
			$oApiIntegratorManager = CApi::Manager('integrator');
			$oAccount = $oApiIntegratorManager->LoginToAccount($sEmail, $sPassword);
			if ($oAccount)
			{
				$oApiIntegratorManager->SetAccountAsLoggedIn($oAccount);
				CApi::Location('mail.php');
			}
			else
			{
				echo $oApiIntegratorManager->GetLastErrorMessage();
			}
		}
		catch (Exception $oException)
		{
			echo $oException->getMessage();
		}
	}
	else
	{
		echo 'AfterLogic API isn\'t available';
	}